﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Diagnostics;
using System.IO;

using Perforce.P4;

namespace x64TestApp
{
    class Program
    {
        const String TestDir = "c:\\MyTestDir";
        
        public class Assert
        {
            public static void IsTrue(bool b)
            {
                if (b)
                    return;
                throw new Exception("Assert FAILED!");
            }
            public static void AreEqual(object a, object b)
            {
                if (a.Equals(b))
                    return;
                throw new Exception("Assert FAILED!");
            }
            public static void AreEqual(string a, string b, bool ignoreCase)
            {
                if (ignoreCase && a.Equals(b, StringComparison.OrdinalIgnoreCase))
                {
                    return;
                }
                else if (ignoreCase && a.Equals(b))
                {
                    return;
                }
                throw new Exception("Assert FAILED!");
            }
        }
        static void Main(string[] args)
        {
            // testGetP4ConfigP4EnvVarWithCWD
            bool unicode = false;

            string server = "localhost:6666";
            string user = "admin";
            string pass = string.Empty;
            string ws_client = "admin_space";

            string oldConfig = P4Server.Get("P4CONFIG");

            for (int i = 0; i < 2; i++) // run once for ascii, once for unicode
            {
                Process p4d = Utilities.DeployP4TestServer(TestDir, unicode);

                try
                {
                    using (Repository rep = new Repository(new Server(new ServerAddress(string.Empty))))
                    {
                        string expected = "C:\\MyTestDir\\admin_space\\MyCode\\myP4Config.txt";
                        P4Server.Set("P4CONFIG", "myP4Config.txt");
                        if (System.IO.File.Exists(expected))
                        {
                            System.IO.File.Delete(expected);
                        }

                        //make sure it returns null if no config file
                        string actual = P4Server.GetConfig("C:\\MyTestDir\\admin_space\\MyCode");
                        if (actual != null)
                        {
                            Assert.AreEqual(actual, "noconfig", true);
                        }
                        using (System.IO.StreamWriter sw = new StreamWriter(expected))
                        {
                            sw.WriteLine(string.Format("P4PORT={0}", server));
                            sw.WriteLine(string.Format("P4USER={0}", user));
                            sw.WriteLine(string.Format("P4CLIENT={0}", ws_client));
                        }

                        actual = P4Server.GetConfig("C:\\MyTestDir\\admin_space\\MyCode");
                        Assert.AreEqual(actual, expected, true);

                        System.Environment.CurrentDirectory = "C:\\MyTestDir\\admin_space\\MyCode";

                        actual = rep.Connection.GetP4ConfigFile(System.Environment.CurrentDirectory);
                        Console.WriteLine("ConfigFile={0}", actual);

                        Options opts = new Options();
                        opts.Add("ProgramName", "P4UnitTest");
                        opts.Add("cwd", System.Environment.CurrentDirectory);

                        using (Connection con = rep.Connection)
                        {
                            Assert.IsTrue(rep.Connection.Connect(opts));

                            actual = rep.Connection.GetP4EnvironmentVar("P4CONFIG");
                            Console.WriteLine("P4CONFIG={0}", actual);
                            Assert.AreEqual(actual, "myP4Config.txt", true);

                            actual = rep.Connection.GetP4ConfigFile();
                            Console.WriteLine("ConfigFile={0}", actual);
                            Assert.AreEqual(actual, expected, true);
                        }
                    }
                }
                finally
                {
                    Utilities.RemoveTestServer(p4d, TestDir);

                    P4Server.Set("P4CONFIG", oldConfig);

                    if (System.IO.File.Exists("C:\\MyTestDir\\admin_space\\MyCode\\myP4Config.txt"))
                    {
                        System.IO.File.Delete("C:\\MyTestDir\\admin_space\\MyCode\\myP4Config.txt");
                    }
                }
                unicode = !unicode;
            }

            Console.WriteLine("Hit enter to exit");
            Console.ReadLine();
        }

    }
}
